/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2000 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally dont change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//
/////////////////////////////////////////////

var xmsgProductLanguage=	"en-us";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgProduct=	"Product: ";
var xmsgsernum=		"Serial Number: ";
var xmsgOsernum=	"Old Serial Number: ";
var xmsgOldSerialNum=	"Old Serial Number:*";
var xmsgNewSernum1=	"New Serial Number";
var xmsgNewSernum2=	"New Serial Number*";
var xmsgRequestCode=	"Request Code: ";
var xmsgRegAuthCode=	"Authorization Code: ";
var xmsgApplicationKey=	"Application Key: ";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Salutation:";
var xmsgFirstname=	"First name:*";
var xmsgFirstname2=	"First name:";
var xmsgLastname=	"Last name:*";
var xmsgLastname2=	"Last name:";
var xmsgCompanyName=	"Company name:*";
var xmsgCompanyName2=	"Company name:";
var xmsgPhone=		"Phone Number:*";
var xmsgPhone2=		"Phone Number:";
var xmsgFax=		"Fax Number:";
var xmsgEmail=		"Email:";
var xmsgAddress=	"Address:*";
var xmsgAddress2=	"Address:";
var xmsgCity=		"City:*";
var xmsgCity2=		"City:";
var xmsgSRP=		"State/Region/Province:";
var xmsgStText=		"State:";
var xmsgPrText=		"Province:";
var xmsgRegText=	"Region:";
var xmsgZipCode=	"Zip Code:";
var xmsgPostCode=	"Post Code:";
var xmsgCountry=	"Country:";
var xmsgDealer=		"Dealer Name:";
var xmsgAppUsageQ1=	"What is the Primary Usage of the Software?";
var xmsgAppUsageQ2=	"Select all that apply:*";
var xmsgAppUsage=	"Primary Usage of the Software:";

///////////////////////////////////////////////
// Salutation RESOURCES HERE:
///////////////////////////////////////////////
var xmsgADM =    		"Adm.";
var xmsgARCH =    		"Arch.";
var xmsgARQ =    		"Arq.";
var xmsgARQA =    		"Arqa.";
var xmsgAVV =    		"Avv.";
var xmsgCA =    		"Ca.";
var xmsgCAPT =    		"Capt.";
var xmsgCOL =    		"Col.";
var xmsgCOMM =    		"Comm.";
var xmsgDHR =    		"Dhr.";
var xmsgDOTT =    		"Dott.";
var xmsgDOTTSSA=    		"Dott.ssa";
var xmsgDR =    		"Dr.";
var xmsgDRA =    		"Dra.";
var xmsgDRS =    		"Drs.";
var xmsgENG =    		"Eng.";
var xmsgENGA =    		"Enga.";
var xmsgFR =    		"Fr.";
var xmsgFRAU =    		"Frau";
var xmsgGEN =    		"Gen.";
var xmsgGEOM =    		"Geom.";
var xmsgHERR =    		"Herr";
var xmsgHERRN =    		"Herrn";
var xmsgING =    		"Ing.";
var xmsgIR =    		"Ir.";
var xmsgLIC =    		"Lic.";
var xmsgLT =    		"Lt.";
var xmsgM =    			"M.";
var xmsgME =    		"Me.";
var xmsgMEVR =    		"Mevr.";
var xmsgMISS =    		"Miss";
var xmsgMLLE =    		"Mlle";
var xmsgMME =    		"Mme";
var xmsgMR =    		"Mr.";
var xmsgMRS =    		"Mrs.";
var xmsgMS =    		"Ms.";
var xmsgNR =    		"Nr.";
var xmsgOFFCR =    		"Officer";
var xmsgPAN =    		"Pan";
var xmsgPANI =    		"Pani";
var xmsgPE =    		"Pe.";
var xmsgPI=    			"Pi.";
var xmsgPM =    		"Pm.";
var xmsgPROF =    		"Prof.";
var xmsgPROFRE =    		"Prof.re";
var xmsgPROFSSA =    		"Prof.ssa";
var xmsgPROFA =    		"Profa.";
var xmsgSIG =    		"Sig.";
var xmsgSIGRA =    		"Sig.ra";
var xmsgSIR =    		"Sir";
var xmsgSR =    		"Sr.";
var xmsgSRA =		    	"Sra.";
var xmsgSRTA =    		"Srta.";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"Back";
var xmsgCancel=			"Cancel";
var xmsgExit=			"Exit";
var xmsgFinish=			"Finish";
var xmsgNext=			"Next";
var xmsgPrint=			"Print";
var xmsgNo=				"No";
var xmsgYes=			"Yes";
var xmsgRegister=		"Register";
var xmsgAuthorize=		"Authorize";


///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Please select ";
var xmsgPleaseSelect2=		"Please select an option and click Next.";
var xmsgSelectCountry=		"Select Country:";
var xmsgInformation=		"Information";
var xmsgCompanyInfo=		"Company Information";
var xmsgContactInfo=		"Contact Information";
var xmsgSoftwareInfo=		"Software Information";
var xmsgConfirmInfo=		"Confirm Information";
var xmsgConfirmInfoTxt=		"Please confirm the information entered below and click Next.";
var xmsgCountryHdr=		"Registration";
var xmsgCountryRegTo=		"This product is to be registered to:";
var xmsgCountryComp=		"Company";
var xmsgCountryIndiv=		"Individual";
var xmsgCountryUpgrade=		"Is this an upgrade?";
var xmsgCountryUpgDetail=	"(If you are registering an upgrade, you will be prompted for your old serial number)";
var xmsgConnectHdr=		"Connect";
var xmsgConnectTxt=		"If you are not already connected to the Internet, please do so now. When you are connected, click Next.";
var xmsgTryAgain=		"Try Again";
var xmsgReEnterOld=		"Re-enter Old Serial Number";
var xmsgNewSernum3=		"Please enter your new serial number and click Next.";
var xmsgNewSernum4=		"Your trial software is installed with a serial number (000-00000000) that \
				 cannot be registered. If you purchased a copy of this software, you were \
				 issued a new serial number. You must use this serial number to authorize and \
				 enable your product for use.";
var xmsgNewSernum5=		"New Serial Number*";
var xmsgNewSernum6=		"Confirm New Serial Number*";
var xmsgNewSernum7=		"The New Serial Number supplied for this registration is not valid. Please select an option and click Next.";
var xmsgNewSernum8=		"Re-enter New Serial Number";
var xmsgUseOtherMethod=		"Use another registration method";
var xmsgContactAutodesk=	"Contact Autodesk";
var xmsgContactOptions=		"contact options are shown below.";

var xmsgPuchaseInfo1=		"Purchase Information";
var xmsgPuchaseInfo2=		"You have chosen to purchase on-line. The following screens:";
var xmsgPuchaseInfo3=		"Collect required information";
var xmsgPuchaseInfo4=		"Store this information on your machine for future registration purposes";
var xmsgPuchaseInfo5=		"Allow you to confirm all steps of the process";
var xmsgPuchaseInfo6=		"Confirm the purchase and authorization of your software";
var xmsgPuchaseInfo7=		"Please click Next to continue, or Cancel if you do not wish to proceed.";

var xmsgRegTitle=		"Register your Autodesk product";
var xmsgRegTitleBuy=		"Purchase Autodesk products online";
var xmsgRegInfo=		"Registration Information";
var xmsgRegInfo2=		"Registration Method";
var xmsgRegInfo3=		"Please select a registration method and click Next.";
var xmsgRegmethod1=		"Connect directly via the Internet";
var xmsgRegmethod2=		"Fax request";
var xmsgRegmethod3=		"Email request";
var xmsgRegmethod4=		"Mail request";
var xmsgRegmethod5=		"Mail Registration";
var xmsgRegmethod6=		"Click Print below and mail this form to:";
var xmsgRegmethod7=		"Fax Registration";
var xmsgRegmethod8=		"Click Print below and fax this form to:";
var xmsgRegmethod9=		"Email Registration";
var xmsgRegmethod10=		"1) Select this entire message (Ctrl-A), copy it (Ctrl-C), and paste it into the email.";
var xmsgRegmethod11=		"2) Send the email to: ";
var xmsgRegmethod12=		"If you email your registration, you will receive a response from Autodesk within 4 business days. You may also contact Autodesk.";
var xmsgRegmethod13=		"Create an email";
var xmsgRegAuthInfo=		"Registration and Authorization";
var xmsgRegAuthInfo1=		"Authorization";
var xmsgRegAuthInfo2=		"Register and authorize (get an authorization code)";
var xmsgRegAuthInfo3=		"Enter authorization code (have an authorization code)"; 
var xmsgRegAuthInfo4=		"Authorization Code";
var xmsgRegAuthInfo5=		"Please select country, enter authorization code and click Next.";
var xmsgRegAuthInfo6=		"Authorization Confirmation";	
var xmsgRegAuthInfo7=		"Thank you for registering - your product is now authorized. Please keep a record of your Serial Number and Authorization Code. Click Print if you want to keep this page for your records.";
var xmsgRegAuthInfo8=		"Registration Confirmation";		
var xmsgRegAuthInfo9=		"Thank you for registering your Autodesk product. This will help us to serve you better in future.";
var xmsgRegAuthInfo10=		"Your registration information is saved in ";		
var xmsgRegErrorHdr=		"Registration Error";
var xmsgRegErrorSystem=		"There is a temporary system problem. Please select an option and click Next.";
var xmsgRegErrorOnline=		"This registration cannot be completed on-line. Please contact Autodesk.";
var xmsgRegErrorPrevReg=	"This serial number is already registered and registration cannot be completed on-line. Please contact Autodesk.";
var xmsgRegErrorMaxAuth=	"You have exceeded the number of authorizations allowed for this product. Please contact Autodesk.";
var xmsgRegErrorInvalidOld=	"The Old Serial Number supplied for this registration is not valid. Please select an option and click Next.";
var xmsgRegErrorData=		"There is a problem with the registration information provided. Please select an option and click Next.";
var xmsgRegErrorNetwork=	'The product you are attempting to register is a network-authorized product \
                                 and must be installed as such. You must uninstall your software and select \
                                 "Network" for the installation type. See the network installation section of \
                                 the Installation Guide.';
var xmsgRegNoResponse=		'There is a temporary system problem preventing on-line authorization. Please select \
				 an option and click Next.';
var xmsgRegErrorAuthEntry=	'There is a problem with the authorization code that you entered. Please select \
				 an option and click Next.';
var xmsgRegErrorAuth=		"There is a problem with the authorization code. Please select an option and click Next.";
var xmsgRegConnError=		"Connection Error";
var xmsgRegConnErrorTxt=	"There is a problem with the Internet connection. Please select an option and click Next.";
var xmsgRegPurchError1=		"Purchase Error";
var xmsgRegPurchError2=		"This purchase transaction was not completed on-line. Please select an option and click Next.";
var xmsgRegPurchError3=		"Use another purchase method";
var xmsgRegPurchError4=		"There is a temporary system problem preventing on-line purchase. Please select an option and click Next.";
var xmsgRegPurchError5=		'Thank you for choosing to purchase Autodesk software, however, on-line purchase is not \
							 currently available.<p>In order to proceed with a purchase, please select from the following \
							 two options:<br>(selecting an option below will open a new browser window)';

var xmsgPurchTransErrHdr=	"Purchase Transaction Error";
var xmsgPurchTransError1=	"A new serial number is required to complete your purchase - no new serial number was issued.<br>Please contact Autodesk.";
var xmsgPurchTransError2=	"An error occurred during confirmation of your serial number with our servers.<br>Please contact Autodesk.";
var xmsgAuthErrHdr=			"Authorization Error";
var xmsgThankForPurchase=	"Thank you for purchasing Autodesk software";
var xmsgAuthError1=			"A temporary problem prevented autorization. \
							Please select an option and click Next.";
var xmsgRentalInfo=			"If you purchased a rental product, the rental period begins when you authorize.";
var xmsgRegLaterInfo=		"To register now, click Register.  If you want to register later, select Help|Buy \
							 Online in your product, and then choose Authorize.";
var xmsgAuthorizeNow=		"Authorize Now";
var xmsgAuthorizeLater=		"Authorize Later";
var xmsgPurchOtherProdInfo=	"If you want to purchase other products, run your software and choose Help|Buy Online.";
var xmsgPurchAdditionalProdInfo=	"If you wish to purchase additional products, you can do this at any time by \
									 clicking on Help|Buy Online.";
var xmsgRegAndAuthInfo=		"your product is registered and authorized.";
var xmsgRegButNotAuthInfo=	"Your product has been registered but not authorized.";
var xmsgRegisteredInfo=		"Your product has been registered.";
var xmsgNotRegOrAuthInfo=	"Your software has not been registered or authorized.";
var xmsgToAuthorizeInfo=	"To authorize now, select Authorize."
var xmsgRegAndActiveRentalInfo=	"your product is registered and the rental period that you purchased is now active.";
var xmsgAuthNowOrLaterInfo=	"If you want to authorize later, select Help|Buy Online and then choose Authorize.";
var xmsgRemindRentalInfo=	"You will receive reminders when you near the end of your rental period."
var xmsgPurchHdr=			"Purchase Confirmation";
var xmsgRentalPurchHdr=		"Rental Purchase";

var xmsgAuthResellerInfo=	"<a href=http://www.autodesk.com/supp/asc/northam/usa/usfindpd.htm target=_blank>Authorized Reseller</a> (http://www.autodesk.com/supp/asc/northam/usa/usfindpd.htm)<br>\
							 Contact your local reseller to complete your purchase.";

/////////////////////////////////////////////
// Online Store Default URL HERE:
/////////////////////////////////////////////
var xmsgOnlineStoreDefaultURL=	"http://www.autodesk.com/estore/usa/index.htm";
var xmsgOnlineStoreURL=			"";
var xmsgOnlineStoreInfo=		"";

function SetOnlineStoreURLInfo() {
	xmsgOnlineStoreInfo=	"<a href=" + xmsgOnlineStoreURL + " target=_blank>Online Store</a> (" + xmsgOnlineStoreURL + ")<br>\
							 Complete your purchase at the Autodesk online store.  If you are unable to \
							 find the product you are looking for at the store, please contact an Authorized Reseller.";
}

	//	Australia
var xmsgOnlineStoreURLAU=		"http://www.modusmedia-asia.com/autodeskau";
	//	Belgium
var xmsgOnlineStoreURLBE=		"http://estore.autodesk.com/dr/v2/ec_MAIN.Entry?SP=10007&amp;SID=25938&amp;CID=0&amp;CUR=56";
	//	Canada
var xmsgOnlineStoreURLCA=		"http://www.autodesk.com/estore/canada/index.htm";
	//	France
var xmsgOnlineStoreURLFR=		"http://estore.autodesk.com/v2.0-img/operations/autodkfr/desc/index.html";
	//	Germany
var xmsgOnlineStoreURLDE=		"http://estore.autodesk.com/v2.0-img/operations/autodkde/desc/";
	//	Hong Kong
var xmsgOnlineStoreURLHK=		"http://www.modusmedia-asia.com/autodeskhk";
	//	Ireland
var xmsgOnlineStoreURLIE=		"http://estore.autodesk.com/v2.0-img/operations/autodkir/desc/";
	//	Italy
var xmsgOnlineStoreURLIT=		"http://estore.autodesk.com/dr/v2/ec_MAIN.Entry?SP=10007&amp;SID=25831&amp;CID=0&amp;CUR=380";
	//	Japan
var xmsgOnlineStoreURLJP=		"http://www.modusmedia-asia.com/autodesk";
	//	Korea
var xmsgOnlineStoreURLKR=		"http://www.modusmedia-asia.com/autodesk";
	//	Netherlands
var xmsgOnlineStoreURLNL=		"http://www.digitalriver.com/v20/plsql/ec_MAIN.Entry?SP=10007&amp;SID=25937&amp;CID=0&amp;CUR=528";
	//	New Zealand
var	xmsgOnlineStoreURLNZ=		"http://www.modusmedia-asia.com/autodesknz";
	//	Singapore
var xmsgOnlineStoreURLSG=		"http://www.modusmedia-asia.com/autodesksg";
	//	Sweden
var xmsgOnlineStoreURLSE=		"http://estore.autodesk.com/dr/v2/ec_MAIN.Entry?SP=10007&amp;SID=25931&amp;CID=0&amp;CUR=752";
	//	Taiwan
var xmsgOnlineStoreURLTW=		"http://www.modusmedia-asia.com/autodesktw";
	//	UK
var xmsgOnlineStoreURLGB=		"http://estore.autodesk.com/v2.0-img/operations/autodkuk/desc/";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Registration Data Saved";
var xmsgRegSunData2=		"The registration data required for client deployment has been saved in ";
var xmsgRegSunData3=		"The Old Serial Number supplied for this upgrade registration is not valid. Please contact your administrator.";
var xmsgRegSunData4=		"This software must be re-installed with a valid Old Serial Number.";
var xmsgRegSunData5=		"Single User Network Installation";
var xmsgRegSunData6=		"In order to complete the Single User Network server installation, some registration information is required. The following pages will:";
var xmsgRegSunData7=		"Collect required information.";
var xmsgRegSunData8=		"Allow for Old Serial Number entry if required for an upgrade.";
var xmsgRegSunData9=		"Store this information on the server for deployment to all client installations.";
var xmsgRegSunData10=		"This software will be registered using the following information. Click Next to proceed.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Product Registration";
var xmsgRegVol2=	"Please select one of the following options and click Next:";
var xmsgRegVol3=	"Register now - select this option to begin on-line registration";
var xmsgRegVol4=	"Register later - select this option to run your software now";
var xmsgRegVol5=	"Don't show me this again";
var xmsgRegVol6=	"(If you wish to register later, you can select the registration option in the Help|About dialog)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Customer Identification";
var xmsgCustIDTitle1=		"Customer ID:";
var xmsgCustIDText2=		"Enter your Customer ID and telephone number below. If you do not have a Customer ID, leave both fields blank. Click Next to continue.";
var xmsgCustIDTitle2=		"Telephone Number:";
var xmsgCustIDTelEx4=		"(example: 03-111-1234)";
var xmsgRegCustIDTel=		"The Customer ID and telephone number that you entered do not match. Please select an option and click Next.";
var xmsgPhoneNoAst=		"Phone Number:";
var xmsgKatakana=		"Katakana company name:*";
var xmsgKatakana2=		"Katakana company name:";
var xmsgDepartment=		"Department name:*";
var xmsgDepartment2=		"Department name:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"Web";
var xmsgFormWebData=	"https://register.autodesk.com";
var xmsgFormWebData2=	'*(Authorization codes can be obtained from your dealer or \
			<a href=https://register.autodesk.com target="_blank">https://register.autodesk.com</a>)';
var xmsgFormEmailHdr=	"email";
var xmsgFormEmailData=	"";
var xmsgFormFaxHdr=		"Fax";
var xmsgFormFaxHdrLocal=	"Fax Local Office";
var xmsgFormFaxHdrReg=	"Fax Registration";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Call";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Mail";
var xmsgFormMailHdrLocal=	"Mail Local Office";
var xmsgFormMailHdrReg=	"Mail Registration";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Purchase Software";
var xmsgFormPurchData=	"http://www.autodesk.com/purchase/usa/index.htm";

var xmsgFormEmailDataUS=	"authcodes@autodesk.com";
var xmsgFormFaxDataUS=	"800-225-6490 or 415-507-4690";
var xmsgFormCallDataUS=	"415-507-4690 or 800-551-1490";			 
var xmsgFormMailDataUS=	"Product Registrations<br>Autodesk Inc<br>111 McInnis Parkway<br>San Rafael, CA 94903";

var xmsgFormEmailDataEMA=	"authcodes.neu@autodesk.com";
var xmsgFormFaxDataEMA=		"+41-32-723-9169";
var xmsgFormMailDataEMA=	"Autodesk Development S.a.r.l.<br>Puits-Godets 6<br>Case postale 35<br>CH-2005 Neuchatel<br>Switzerland";

var xmsgFormEmailDataAPC=	"ap.register@autodesk.com";
var xmsgFormFaxDataAPC=		"65-4700-728";
var xmsgFormMailDataAPC=	"Autodesk Asia Pte. Ltd.<br>Alexandra Post Office<br>P.O. Box 225<br>Singapore 911508";

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var xmsgPrivacy=                           'The information you provide will be used by Autodesk to register and/or issue \
			your authorization code, to keep you informed about our products and services, \
			and to ensure that you benefit from being an authorized Autodesk user. Autodesk  \
                                                      does not sell or otherwise provide your information to anyone outside of Autodesk  \
			or our Authorized Business Partners.<br><br> \
			To correct or update your registration data: In U.S., Canada, or Latin America follow the instructions \
			included in the Change of Address page at <a href=http://autodeskgs.custhelp.com/cgi-bin/autodeskgs/faq target="_blank"> \
			http://autodeskgs.custhelp.com/cgi-bin/autodeskgs/faq</a>.\
			In Europe, Middle East, or Africa (EMEA) email <a href="mailto:authcodes.neu@autodesk.com">\
			authcodes.neu@autodesk.com</a>, or fax +41-32-723-9169.\
			In Asia Pacific email <a href="mailto:ap.register@autodesk.com"> \
			ap.register@autodesk.com</a> or <a href="mailto:japan.register@autodesk.com"> \
			japan.register@autodesk.com</a> (for Japan only), or fax +65-4700728.\
			';


/////////////////////////////////////////////

//=======================================================================
// Header Insert Blocks
//=======================================================================

// Set Registration Info Header
var InsertRegInfo =     ' <br><p><b>'+xmsgRegInfo+'</b></p>\
			  <p>Fields marked in <font color="red"> red</font>\
  			  and with an asterisk &nbsp(<font color="red">*</font>)&nbsp\
			  are required to process your registration. Complete the form\
                          and click Next.</p>';

// Set Confirm Info Header
var InsertConfirmInfo = ' <br><p><b>'+xmsgConfirmInfo+'</b></p>\
			  <p>'+xmsgConfirmInfoTxt+'</p>';

// Set the Software Info Header
var InsertSoftwareBar = ' <b>'+xmsgSoftwareInfo+'</b>';

// Set the Primary Application Usage Header
var InsertAppUsageBar = '<b>'+xmsgAppUsageQ1+'</b><br>\
			 <font color="red">'+xmsgAppUsageQ2+'</font>';

//=======================================================================
// Serial Number & License Insert Blocks
//=======================================================================

// Set Product Confirm Field <CONFIRM>
var ProductConfirm = ' <tr>\
			  <td>'+xmsgProduct+'&nbsp;</td>\
			  <td valign="top" align="left"><font color="#848284">'+product+'</font></td>\
			</tr>';

// Set Serial Number Field <CONFIRM>
var sernumConfirm = ' <tr>\
			  <td>'+xmsgsernum+'&nbsp;</td>\
			  <td valign="top" align="left"><font color="#848284">'+sernum+'</font></td>\
			</tr>';

// Set Request Code <CONFIRM>
if (reqtype == "2") {
	var RC = '	<tr>\
				  <td>'+xmsgApplicationKey+'&nbsp;</td>\
				  <td valign="top" align="left"><font color="#848284">'+req+'</font></td>\
				</tr>';
} else {
	var RC = '	<tr>\
				  <td>'+xmsgRequestCode+'&nbsp;</td>\
				  <td valign="top" align="left"><font color="#848284">'+req+'</font></td>\
				</tr>';
}

// Set Authcode <CONFIRM>
var authConfirm = '<tr><td>'+xmsgRegAuthCode+'</td>\
					   <td valign="top" align="left"><font color="#848284">'+auth+'</font></td>\
				   </tr>';

// Set Old Serial Number <ENTER>
var UpgradeSerialBlock = '<p><font color="red">'+xmsgOldSerialNum+'</font><br>\
			  <input type="text" name="osernum" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

// Set Old Serial Number <ENTER - Red>
var UpgradeSerialBlockBlack = '<p><font color="red">'+xmsgOldSerialNum+'<font><br>\
			  <input type="text" name="osernum" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

// Set Old Serial Number Field <CONFIRM - Red>
var OSN = ' <tr>\
			  <td><font color="red">'+xmsgOldSerialNum+'&nbsp;</font></td>\
			  <td><font color="#848284">'+osernum+'</font></td>\
			</tr>';

// Set Old Serial Number Field <CONFIRM - Grey>
var OSNGrey = ' <tr>\
			  <td>'+xmsgOsernum+'&nbsp;</td>\
			  <td><font color="#848284">'+osernum+'</font></td>\
			</tr>';

// New Serial Number <ENTER>
var NewSerialBlock = '<p><font color="red">'+xmsgNewSernum5+'</font><br>\
			  <input type="text" name="nsernum" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

// New Serial Number <RE-ENTER>
var NewSerialBlock2 = '<p><font color="red">'+xmsgNewSernum6+'</font><br>\
			  <input type="text" name="nsernumconfirm" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

//=======================================================================
// Salutation Insert Blocks
//=======================================================================

var SalutationUS = '      <select name="sal" size="1">\
                          <option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="ADM">'+xmsgADM +'</option>\
				<option value="CAPT">'+xmsgCAPT +'</option>\
				<option value="DR">'+xmsgDR +'</option>\
				<option value="DRA">'+xmsgDRA +'</option>\
				<option value="GEN">'+xmsgGEN +'</option>\
				<option value="ING">'+xmsgING +'</option>\
				<option value="LIC">'+xmsgLIC +'</option>\
				<option value="LT">'+xmsgLT +'</option>\
				<option value="M">'+xmsgM +'</option>\
				<option value="MISS">'+xmsgMISS +'</option>\
				<option value="MLLE">'+xmsgMLLE +'</option>\
				<option value="MME">'+xmsgMME +'</option>\
				<option value="MR">'+xmsgMR +'</option>\
				<option value="MRS">'+xmsgMRS +'</option>\
				<option value="MS">'+xmsgMS +'</option>\
				<option value="NR">'+xmsgNR+'</option>\
				<option value="OFFCR">'+xmsgOFFCR +'</option>\
				<option value="PROF">'+xmsgPROF +'</option>\
				<option value="SIR">'+xmsgSIR +'</option>\
				<option value="SR">'+xmsgSR +'</option>\
				<option value="SRA">'+xmsgSRA +'</option>\
				<option value="SRTA">'+xmsgSRTA+'</option>\
                        </select>';

var SalutationAPC = '      <select name="sal" size="1">\
                          <option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="ADM">'+xmsgADM +'</option>\
				<option value="CAPT">'+xmsgCAPT +'</option>\
				<option value="COL">'+xmsgCOL +'</option>\
				<option value="COMM">'+xmsgCOMM +'</option>\
				<option value="DR">'+xmsgDR +'</option>\
				<option value="GEN">'+xmsgGEN +'</option>\
				<option value="ING">'+xmsgING +'</option>\
				<option value="LIC">'+xmsgLIC +'</option>\
				<option value="LT">'+xmsgLT +'</option>\
				<option value="MISS">'+xmsgMISS +'</option>\
				<option value="MR">'+xmsgMR +'</option>\
				<option value="MRS">'+xmsgMRS +'</option>\
				<option value="MS">'+xmsgMS +'</option>\
				<option value="NR">'+xmsgNR +'</option>\
				<option value="PROF">'+xmsgPROF +'</option>\
				<option value="SIR">'+xmsgSIR +'</option>\
				<option value="SR">'+xmsgSR +'</option>\
				<option value="SRA">'+xmsgSRA +'</option>\
				<option value="SRTA">'+xmsgSRTA +'</option>\
                        </select>';

var SalutationEMA = '      <select name="sal" size="1">\
                          <option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="ARCH">'+xmsgARCH +'</option>\
				<option value="ARQ">'+xmsgARQ +'</option>\
				<option value="ARQA">'+xmsgARQA +'</option>\
				<option value="AVV">'+xmsgAVV +'</option>\
				<option value="CA">'+xmsgCA +'</option>\
				<option value="DHR">'+xmsgDHR +'</option>\
				<option value="DOTT">'+xmsgDOTT +'</option>\
				<option value="DOTT.SSA">'+xmsgDOTTSSA+'</option>\
				<option value="DR">'+xmsgDR +'</option>\
				<option value="DRA">'+xmsgDRA +'</option>\
				<option value="DRS">'+xmsgDRS +'</option>\
				<option value="ENG">'+xmsgENG +'</option>\
				<option value="ENGA">'+xmsgENGA +'</option>\
				<option value="FR">'+xmsgFR +'</option>\
				<option value="FRAU">'+xmsgFRAU +'</option>\
				<option value="GEOM">'+xmsgGEOM +'</option>\
				<option value="HERR">'+xmsgHERR +'</option>\
				<option value="HERRN">'+xmsgHERRN +'</option>\
				<option value="ING">'+xmsgING +'</option>\
				<option value="IR">'+xmsgIR +'</option>\
				<option value="LIC">'+xmsgLIC +'</option>\
				<option value="M">'+xmsgM +'</option>\
				<option value="ME">'+xmsgME +'</option>\
				<option value="MEVR">'+xmsgMEVR +'</option>\
				<option value="MISS">'+xmsgMISS +'</option>\
				<option value="MLLE">'+xmsgMLLE +'</option>\
				<option value="MME">'+xmsgMME +'</option>\
				<option value="MR">'+xmsgMR +'</option>\
				<option value="MRS">'+xmsgMRS +'</option>\
				<option value="MS">'+xmsgMS +'</option>\
				<option value="PAN">'+xmsgPAN +'</option>\
				<option value="PANI">'+xmsgPANI +'</option>\
				<option value="PE">'+xmsgPE +'</option>\
				<option value="PI">'+xmsgPI+'</option>\
				<option value="PM">'+xmsgPM +'</option>\
				<option value="PROF">'+xmsgPROF +'</option>\
				<option value="PROF.RE">'+xmsgPROFRE +'</option>\
				<option value="PROF.SSA">'+xmsgPROFSSA +'</option>\
				<option value="PROFA">'+xmsgPROFA +'</option>\
				<option value="SIG">'+xmsgSIG +'</option>\
				<option value="SIG.RA">'+xmsgSIGRA +'</option>\
				<option value="SIR">'+xmsgSIR +'</option>\
				<option value="SR">'+xmsgSR +'</option>\
				<option value="SRA">'+xmsgSRA +'</option>\
				<option value="SRTA">'+xmsgSRTA+'</option>\
                        </select>';


//=======================================================================
// Rolodex Insert Blocks
//=======================================================================

// Set the Company Name <ENTER> Text Block. Contains [Company Text, Company Field]
var InsertCompanyBlock = ' <b>'+xmsgCompanyInfo+'</b><br>\
						   <br><font color="red">'+xmsgCompanyName+'<br>\
						     <input type="text" name="comp" size="62" maxlength="40"></font>';

// Set the Contact Name <ENTER> Text Block [Salutation, First Name, Last Name]
var InsertNameBlock = ' <p><font color="red">'+xmsgFirstname+'<br>\
			   <input type="text" name="fname" size="62" maxlength="40"></font></p>\
			<p><font color="red">'+xmsgLastname+'<br>\
			   <input type="text" name="lname" size="62" maxlength="40"></font></p>';

//=======================================================================
// Register Info Insert Blocks
//=======================================================================

var RegInfoConfirm = xmsgRegAuthInfo10 + '<a href="' + reginfofolder + '" target="_blank">' + reginfofolder + '</a>';

//=======================================================================
// State, Region, and Province Information
//=======================================================================

// Set State Region Province field
var SRP =   xmsgSRP+'<br><font color="#848284">'+state+'</font><br>';

// Country State/Province Info
var ATStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="B">Burgenland </option>\
						<option value="K">Krnten </option>\
						<option value="N">Niedersterreich </option>\
						<option value="O">Obersterreich </option>\
						<option value="S">Salzburg </option>\
						<option value="ST">Steiermark </option>\
						<option value="T">Tirol </option>\
						<option value="V">Vorarlberg </option>\
						<option value="W">Wien </option>\
						</select>';

var AUStPrRegHTML = '	<br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="ACT">Aust Capital Terr </option>\
						<option value="NSW">New South Wales </option>\
						<option value="NT">Northern Territory </option>\
						<option value="QLD">Queensland </option>\
						<option value="SA">South Australia </option>\
						<option value="TAS">Tasmania </option>\
						<option value="VIC">Victoria </option>\
						<option value="WA">Western Australia </option>\
						</select>';

var USStPrRegHTML = '	<br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AL">Alabama </option>\
						<option value="AK">Alaska </option>\
						<option value="AZ">Arizona </option>\
						<option value="AR">Arkansas </option>\
						<option value="CA">California </option>\
						<option value="CO">Colorado </option>\
						<option value="CT">Connecticut </option>\
						<option value="DE">Delaware </option>\
						<option value="DC">District of Columbia </option>\
						<option value="FL">Florida </option>\
						<option value="GA">Georgia </option>\
						<option value="HI">Hawaii </option>\
						<option value="ID">Idaho </option>\
						<option value="IL">Illinois </option>\
						<option value="IN">Indiana </option>\
						<option value="IA">Iowa </option>\
						<option value="KS">Kansas </option>\
						<option value="KY">Kentucky </option>\
						<option value="LA">Louisiana </option>\
						<option value="ME">Maine </option>\
						<option value="MD">Maryland </option>\
						<option value="MA">Massachusetts </option>\
						<option value="MI">Michigan </option>\
						<option value="MN">Minnesota </option>\
						<option value="MS">Mississippi </option>\
						<option value="MO">Missouri </option>\
						<option value="MT">Montana </option>\
						<option value="NE">Nebraska </option>\
						<option value="NV">Nevada </option>\
						<option value="NH">New Hampshire </option>\
						<option value="NJ">New Jersey </option>\
						<option value="NM">New Mexico </option>\
						<option value="NY">New York </option>\
						<option value="NC">North Carolina </option>\
						<option value="ND">North Dakota </option>\
						<option value="OH">Ohio </option>\
						<option value="OK">Oklahoma </option>\
						<option value="OR">Oregon </option>\
						<option value="PA">Pennsylvania </option>\
						<option value="RI">Rhode Island </option>\
						<option value="SC">South Carolina </option>\
						<option value="SD">South Dakota </option>\
						<option value="TN">Tennessee </option>\
						<option value="TX">Texas </option>\
						<option value="UT">Utah </option>\
						<option value="VT">Vermont </option>\
						<option value="VA">Virginia </option>\
						<option value="VI">Virgin Islands</option>\
						<option value="WA">Washington </option>\
						<option value="WV">West Virginia </option>\
						<option value="WI">Wisconsin </option>\
						<option value="WY">Wyoming </option>\
						<option value="AA">APOAmerica</option>\
						<option value="AE">APOEurope</option>\
						<option value="AP">APOPacific</option>\
						</select>';

var CAStPrRegHTML = '	<br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AB">Alberta </option>\
						<option value="BC">British Columbia </option>\
						<option value="MB">Manitoba </option>\
						<option value="NB">New Brunswick </option>\
						<option value="NF">Newfoundland </option>\
						<option value="NT">Northwest Territories </option>\
						<option value="NS">Nova Scotia </option>\
						<option value="NU">Nunavut </option>\
						<option value="ON">Ontario </option>\
						<option value="PE">Prince Edward Island </option>\
						<option value="QC">Quebec </option>\
						<option value="SK">Saskatchewan </option>\
						<option value="YT">Yukon </option>\
						<option value="ZZ">Outside province </option>\
						</select>';

var CHStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AG">Aargau </option>\
						<option value="AI">Appenzell Innerrhoden </option>\
						<option value="AR">Appenzell Ausserrhoden </option>\
						<option value="BE">Bern </option>\
						<option value="BL">Basel-Landschaft </option>\
						<option value="BS">Basel-Stadt </option>\
						<option value="FR">Fribourg </option>\
						<option value="GE">Genve </option>\
						<option value="GL">Glarus </option>\
						<option value="GR">Graubenden </option>\
						<option value="JU">Jura </option>\
						<option value="LU">Luzern </option>\
						<option value="NE">Neuchtel </option>\
						<option value="NW">Nidwalden </option>\
						<option value="OW">Obwalden </option>\
						<option value="SG">St.Gallen </option>\
						<option value="SH">Schaffhausen </option>\
						<option value="SO">Solothurn </option>\
						<option value="SZ">Schwyz </option>\
						<option value="TG">Thurgau </option>\
						<option value="TI">Ticino </option>\
						<option value="UR">Uri </option>\
						<option value="VD">Vaud </option>\
						<option value="VS">Valais </option>\
						<option value="ZG">Zug </option>\
						<option value="ZH">Zrich </option>\
						</select>';

var CNStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="110">Anhui </option>\
						<option value="010">Beijing </option>\
						<option value="150">Fujian </option>\
						<option value="260">Gansu </option>\
						<option value="190">Guangdong </option>\
						<option value="210">Guangxi </option>\
						<option value="220">Guizhou </option>\
						<option value="200">Hainan </option>\
						<option value="060">Hebei </option>\
						<option value="090">Heilongjiang </option>\
						<option value="180">Henan </option>\
						<option value="170">Hubei </option>\
						<option value="160">Hunan </option>\
						<option value="100">Jiangsu </option>\
						<option value="140">Jiangxi </option>\
						<option value="080">Jilin </option>\
						<option value="070">Liaoning </option>\
						<option value="040">NeiMongol </option>\
						<option value="270">Ningxia </option>\
						<option value="280">Qinghai </option>\
						<option value="250">Shaanxi </option>\
						<option value="120">Shandong </option>\
						<option value="020">Shanghai </option>\
						<option value="050">Shanxi </option>\
						<option value="230">Sichuan </option>\
						<option value="030">Tianjin </option>\
						<option value="290">Xinjiang </option>\
						<option value="300">Xizang </option>\
						<option value="240">Yunnan </option>\
						<option value="130">Zhejiang </option>\
						</select>';

var DEStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="08">Baden-Wrttemberg </option>\
						<option value="09">Bayern </option>\
						<option value="11">Berlin </option>\
						<option value="12">Brandenburg </option>\
						<option value="04">Bremen </option>\
						<option value="02">Hamburg </option>\
						<option value="06">Hessen </option>\
						<option value="13">Mecklenburg-Vorpommern </option>\
						<option value="03">Niedersachsen </option>\
						<option value="05">Nordrhein-Westfalen </option>\
						<option value="07">Rheinland-Pfalz </option>\
						<option value="10">Saarland </option>\
						<option value="14">Sachsen </option>\
						<option value="15">Sachsen-Anhalt</option>\
						<option value="01">Schleswig-Holstein </option>\
						<option value="16">Thringen </option>\
						</select>';

var ESStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="01">lava </option>\
						<option value="02">Albacete </option>\
						<option value="03">Alicante </option>\
						<option value="04">Almera </option>\
						<option value="33">Asturias </option>\
						<option value="05">vila </option>\
						<option value="06">Badajoz </option>\
						<option value="07">Baleares </option>\
						<option value="08">Barcelona </option>\
						<option value="09">Burgos </option>\
						<option value="10">Cceres </option>\
						<option value="11">Cdiz </option>\
						<option value="39">Cantabria </option>\
						<option value="12">Castelln </option>\
						<option value="13">CiudadReal </option>\
						<option value="14">Crdoba </option>\
						<option value="16">Cuenca </option>\
						<option value="17">Gerona </option>\
						<option value="18">Granada </option>\
						<option value="19">Guadalajara </option>\
						<option value="20">Guipzcoa </option>\
						<option value="21">Huelva </option>\
						<option value="22">Huesca </option>\
						<option value="23">Jan </option>\
						<option value="15">LaCorua </option>\
						<option value="26">LaRioja </option>\
						<option value="35">LasPalmas </option>\
						<option value="24">Len </option>\
						<option value="25">Lrida </option>\
						<option value="27">Lugo </option>\
						<option value="28">Madrid </option>\
						<option value="29">Mlaga </option>\
						<option value="30">Murcia </option>\
						<option value="31">Navarra </option>\
						<option value="32">Orense </option>\
						<option value="34">Palencia </option>\
						<option value="36">Pontevedra </option>\
						<option value="37">Salamanca </option>\
						<option value="38">Santa Cruz de Tenerife </option>\
						<option value="40">Segovia </option>\
						<option value="41">Sevilla </option>\
						<option value="42">Soria </option>\
						<option value="43">Tarragona </option>\
						<option value="44">Teruel </option>\
						<option value="45">Toledo </option>\
						<option value="46">Valencia </option>\
						<option value="47">Valladolid </option>\
						<option value="48">Vizcaya </option>\
						<option value="49">Zamora </option>\
						<option value="50">Zaragoza </option>\
						</select>';

var HKStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="HK">Hong Kong Island </option>\
						<option value="KLN">Kowloon </option>\
						<option value="NT">New Territories </option>\
						</select>';

var IEStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="CK">Cork </option>\
						<option value="CL">Clare </option>\
						<option value="CW">Carlow </option>\
						<option value="DB">Dublin </option>\
						<option value="DG">Donegal </option>\
						<option value="GW">Galway </option>\
						<option value="KD">Kildare </option>\
						<option value="KK">Kilkenny </option>\
						<option value="KV">Cavan </option>\
						<option value="KY">Kerry </option>\
						<option value="LF">Longford </option>\
						<option value="LI">Limerick </option>\
						<option value="LM">Leitrim </option>\
						<option value="LS">Laois </option>\
						<option value="LT">Louth </option>\
						<option value="MH">Monaghan </option>\
						<option value="MT">Meath </option>\
						<option value="MY">Mayo </option>\
						<option value="OS">Offaly </option>\
						<option value="RC">Rosscommon </option>\
						<option value="SG">Sligo </option>\
						<option value="TP">Tipperary </option>\
						<option value="WF">Waterford </option>\
						<option value="WK">Wicklow </option>\
						<option value="WM">Westmeath </option>\
						<option value="WX">Wexford </option>\
						</select>';

var ITStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AG">Agrigento </option>\
						<option value="AL">Alessandria </option>\
						<option value="AN">Ancona </option>\
						<option value="AO">Aosta </option>\
						<option value="AR">Arezzo </option>\
						<option value="AP">Ascoli Piceno </option>\
						<option value="AT">Asti </option>\
						<option value="AV">Avellino </option>\
						<option value="BA">Bari </option>\
						<option value="BL">Belluno </option>\
						<option value="BN">Benevento </option>\
						<option value="BG">Bergamo </option>\
						<option value="BI">Biella </option>\
						<option value="BO">Bologna </option>\
						<option value="BZ">Bolzano </option>\
						<option value="BS">Brescia </option>\
						<option value="BR">Brindisi </option>\
						<option value="CA">Cagliari </option>\
						<option value="CL">Caltanissetta </option>\
						<option value="CB">Campobasso </option>\
						<option value="CE">Caserta </option>\
						<option value="CT">Catania </option>\
						<option value="CZ">Catanzaro </option>\
						<option value="CH">Chieti </option>\
						<option value="CO">Como </option>\
						<option value="CS">Cosenza </option>\
						<option value="CR">Cremona </option>\
						<option value="KR">Crotone </option>\
						<option value="CN">Cuneo </option>\
						<option value="EN">Enna </option>\
						<option value="FE">Ferrara </option>\
						<option value="FI">Firenze </option>\
						<option value="FG">Foggia </option>\
						<option value="FO">Forl </option>\
						<option value="FR">Frosinone </option>\
						<option value="GE">Genova </option>\
						<option value="GO">Gorizia </option>\
						<option value="GR">Grosseto </option>\
						<option value="IM">Imperia </option>\
						<option value="IS">Isernia </option>\
						<option value="AQ">L`Aquila </option>\
						<option value="SP">LaSpezia </option>\
						<option value="LT">Latina </option>\
						<option value="LE">Lecce </option>\
						<option value="LC">Lecco </option>\
						<option value="LI">Livorno </option>\
						<option value="LO">Lodi </option>\
						<option value="LU">Lucca </option>\
						<option value="MC">Macerata </option>\
						<option value="MN">Mantova </option>\
						<option value="MS">Massa Carrara </option>\
						<option value="MT">Matera </option>\
						<option value="ME">Messina </option>\
						<option value="MI">Milano </option>\
						<option value="MO">Modena </option>\
						<option value="NA">Napoli </option>\
						<option value="NO">Novara </option>\
						<option value="NU">Nuoro </option>\
						<option value="OR">Oristano </option>\
						<option value="PD">Padova </option>\
						<option value="PA">Palermo </option>\
						<option value="PR">Parma </option>\
						<option value="PV">Pavia </option>\
						<option value="PG">Perugia </option>\
						<option value="PS">Pesaro e Urbino </option>\
						<option value="PE">Pescara </option>\
						<option value="PC">Piacenza </option>\
						<option value="PI">Pisa </option>\
						<option value="PT">Pistoia </option>\
						<option value="PN">Pordenone </option>\
						<option value="PZ">Potenza </option>\
						<option value="PO">Prato </option>\
						<option value="RG">Ragusa </option>\
						<option value="RA">Ravenna </option>\
						<option value="RC">Reggio Calabria </option>\
						<option value="RE">Reggio Emilia </option>\
						<option value="RI">Rieti </option>\
						<option value="RN">Rimini </option>\
						<option value="RM">Roma </option>\
						<option value="RO">Rovigo </option>\
						<option value="SA">Salerno </option>\
						<option value="SS">Sassari </option>\
						<option value="SV">Savona </option>\
						<option value="SI">Siena </option>\
						<option value="SR">Siracusa </option>\
						<option value="SO">Sondrio </option>\
						<option value="TA">Taranto </option>\
						<option value="TE">Teramo </option>\
						<option value="TR">Terni </option>\
						<option value="TP">Trapani </option>\
						<option value="TN">Trento </option>\
						<option value="TV">Treviso </option>\
						<option value="TS">Trieste </option>\
						<option value="TO">Torino </option>\
						<option value="UD">Udine </option>\
						<option value="VA">Varese </option>\
						<option value="VE">Venice </option>\
						<option value="VB">Verbano-Cusio-Ossola </option>\
						<option value="VC">Vercelli </option>\
						<option value="VR">Verona </option>\
						<option value="VV">Vibo Valentia </option>\
						<option value="VI">Vicenza </option>\
						<option value="VT">Viterbo </option>\
						</select>';


var JPStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="23">Aichi-ken </option>\
						<option value="05">Akita-ken </option>\
						<option value="02">Aomori-ken </option>\
						<option value="12">Chiba-ken </option>\
						<option value="38">Ehime-ken </option>\
						<option value="18">Fukui-ken </option>\
						<option value="40">Fukuoka-ken </option>\
						<option value="07">Fukushima-ken </option>\
						<option value="21">Gifu-ken </option>\
						<option value="10">Gunma-ken </option>\
						<option value="34">Hiroshima-ken </option>\
						<option value="01">Hokkaido </option>\
						<option value="28">Hyogo-ken </option>\
						<option value="08">Ibaragi-ken </option>\
						<option value="17">Ishikawa-ken </option>\
						<option value="03">Iwate-ken </option>\
						<option value="37">Kagawa-ken </option>\
						<option value="46">Kagoshima-ken </option>\
						<option value="14">Kanagawa-ken </option>\
						<option value="39">Kochi-ken </option>\
						<option value="43">Kumamoto-ken </option>\
						<option value="26">Kyoto-fu </option>\
						<option value="24">Mie-ken </option>\
						<option value="04">Miyagi-ken </option>\
						<option value="45">Miyazaki-ken </option>\
						<option value="42">Nagasaki-ken </option>\
						<option value="20">Nagano-ken </option>\
						<option value="29">Nara-ken </option>\
						<option value="15">Niigata-ken </option>\
						<option value="44">Oita-ken </option>\
						<option value="33">Okayama-ken </option>\
						<option value="47">Okinawa-ken </option>\
						<option value="27">Osaka-fu </option>\
						<option value="41">Saga-ken </option>\
						<option value="11">Saitama-ken </option>\
						<option value="25">Shiga-ken </option>\
						<option value="32">Shimane-ken </option>\
						<option value="22">Shizuoka-ken </option>\
						<option value="09">Tochigi-ken </option>\
						<option value="36">Tokushima-ken </option>\
						<option value="13">Tokyo-to </option>\
						<option value="31">Tottori-ken </option>\
						<option value="16">Toyama-ken </option>\
						<option value="30">Wakayama-ken </option>\
						<option value="06">Yamagata-ken </option>\
						<option value="35">Yamaguchi-ken </option>\
						<option value="19">Yamanashi-ken </option>\
						</select>';

var MXStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AGS">Aguascalientes </option>\
						<option value="BCN">Baja CaliforniaN </option>\
						<option value="BCS">Baja CaliforniaS </option>\
						<option value="CMP">Campeche </option>\
						<option value="CHS">Chiapas </option>\
						<option value="CHI">Chihuahua </option>\
						<option value="COA">Coahuila </option>\
						<option value="COL">Colima </option>\
						<option value="DF">DistritoFederal </option>\
						<option value="DGO">Durango </option>\
						<option value="MEX">Estado de Mxico </option>\
						<option value="GTO">Guanajuato </option>\
						<option value="GRO">Guerrero </option>\
						<option value="HGO">Hidalgo </option>\
						<option value="JAL">Jalisco </option>\
						<option value="MCH">Michoacn </option>\
						<option value="MOR">Morelos </option>\
						<option value="NL">NuevoLon </option>\
						<option value="OAX">Oaxaca </option>\
						<option value="PUE">Puebla </option>\
						<option value="QRO">Quertaro </option>\
						<option value="QR">QuintanaRoo </option>\
						<option value="SLP">San Luis Potos </option>\
						<option value="SIN">Sinaloa </option>\
						<option value="SON">Sonora </option>\
						<option value="TAB">Tabasco </option>\
						<option value="TMS">Tamaulipas </option>\
						<option value="TLX">Tlaxcala </option>\
						<option value="VER">Veracruz </option>\
						<option value="YUC">Yucatn </option>\
						<option value="ZAC">Zacatecas </option>\
						</select>';

var MYStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="JOH">Johor </option>\
						<option value="KED">Kedah </option>\
						<option value="KEL">Kelantan </option>\
						<option value="KUL">KualaLumpur </option>\
						<option value="LAB">Labuan </option>\
						<option value="MEL">Melaka </option>\
						<option value="PAH">Pahang </option>\
						<option value="PEL">Perlis </option>\
						<option value="PER">Perak </option>\
						<option value="PIN">PulauPinang </option>\
						<option value="SAB">Sabah </option>\
						<option value="SAR">Sarawak </option>\
						<option value="SEL">Selangor </option>\
						<option value="SER">NegeriSembilan </option>\
						<option value="TRE">Terengganu </option>\
						</select>';

var PTStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="40">Alentejo </option>\
						<option value="50">Algarve </option>\
						<option value="24">Beira Interior </option>\
						<option value="15">Beira Litoral </option>\
						<option value="10">Entre Douro e Minho </option>\
						<option value="22">Estremadura e Ribatejo </option>\
						<option value="31">Lisboa e Setbal </option>\
						<option value="70">Reg. Aut. da Madeira </option>\
						<option value="60">Reg. Aut. dos Aores </option>\
						<option value="16">Trs-os-Montes e Alto Douro </option>\
						</select>';

var TWStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="KSH">Kaoshung City </option>\
						<option value="TPE">Taipei City </option>\
						<option value="TWN">Taiwan Prov. </option>\
						</select>';


// Set the State Confirmation Field (Long Name)
var SRP =   xmsgSRP+'<br><font color="#848284">'+state+'</font><br>';

//=======================================================================
// Zip and Postal Code Information
//=======================================================================

var ZipHTML= ' <p>'+xmsgZipCode+'<br>\
			   <input type="text" name="zip" size="10" maxlength="10">\
			   </p>';

//Zip confirmation
var ZipHTMLConfirm= ' <p>'+xmsgZipCode+'<br>\
			   <font color="#848284">'+zip+'</font>\
			   </p>';

var PostHTML= ' <p>'+xmsgPostCode+'<br>\
				<input type="text" name="zip" size="10" maxlength="10">\
				</p>';

// Postal Confirmation
var PostHTMLConfirm= ' <p>'+xmsgPostCode+'<br>\
			   <font color="#848284">'+zip+'</font>\
  			   </p>';

var CanPostHTML= ' <p>'+xmsgPostCode+'<br>\
				   <input type="text" name="zip" size="3" maxlength="3">-\
				   <input type="text" name="zip" size="3" maxlength="3">\
				   </p>';

//=======================================================================
// Country Long Name Information
//=======================================================================

var CountryHTML= xmsgSelectCountry+'<br>\
				<select name="country" size="1">\
				<option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="US">United States </option>\
				<option value="AL">Albania </option>\
				<option value="DZ">Algeria </option>\
				<option value="AS">American Samoa </option>\
				<option value="AD">Andorra </option>\
				<option value="AO">Angola </option>\
				<option value="AI">Anguilla </option>\
				<option value="AQ">Antarctica </option>\
				<option value="AG">Antigua and Barbuda </option>\
				<option value="AR">Argentina </option>\
				<option value="AM">Armenia </option>\
				<option value="AW">Aruba </option>\
				<option value="AU">Australia </option>\
				<option value="AT">Austria </option>\
				<option value="AZ">Azerbaijan </option>\
				<option value="BS">Bahamas </option>\
				<option value="BH">Bahrain </option>\
				<option value="BD">Bangladesh </option>\
				<option value="BB">Barbados </option>\
				<option value="BY">Belarus </option>\
				<option value="BE">Belgium </option>\
				<option value="BZ">Belize </option>\
				<option value="BJ">Benin </option>\
				<option value="BM">Bermuda </option>\
				<option value="BT">Bhutan </option>\
				<option value="BO">Bolivia </option>\
				<option value="BA">Bosnia and Herzegovina </option>\
				<option value="BW">Botswana </option>\
				<option value="BV">Bouvet Island </option>\
				<option value="BR">Brazil </option>\
				<option value="IO">British Indian Ocean Territory </option>\
				<option value="BN">Brunei Darussalam </option>\
				<option value="BG">Bulgaria </option>\
				<option value="BF">Burkina Faso </option>\
				<option value="BI">Burundi </option>\
				<option value="KH">Cambodia </option>\
				<option value="CM">Cameroon </option>\
				<option value="CA">Canada </option>\
				<option value="CV">Cape Verde </option>\
				<option value="KY">Cayman Islands </option>\
				<option value="CF">Central African Republic </option>\
				<option value="TD">Chad </option>\
				<option value="CL">Chile </option>\
				<option value="CN">China </option>\
				<option value="CX">Christmas Island (Australia) </option>\
				<option value="CC">Cocos (Keeling) Islands </option>\
				<option value="CO">Colombia </option>\
				<option value="KM">Comoros </option>\
				<option value="CG">Congo </option>\
				<option value="CK">Cook Islands (New Zealand) </option>\
				<option value="CR">Costa Rica </option>\
				<option value="CI">Cote d`Ivoire </option>\
				<option value="HR">Croatia (Hrvatska) </option>\
				<option value="CY">Cyprus </option>\
				<option value="CZ">Czech Republic </option>\
				<option value="CD">Democratic Republic of the Congo </option>\
				<option value="DK">Denmark </option>\
				<option value="DJ">Djibouti </option>\
				<option value="DM">Dominica </option>\
				<option value="DO">Dominican Republic </option>\
				<option value="TP">East Timor </option>\
				<option value="EC">Ecuador </option>\
				<option value="EG">Egypt </option>\
				<option value="SV">El Salvador </option>\
				<option value="GQ">Equatorial Guinea </option>\
				<option value="ER">Eritrea </option>\
				<option value="EE">Estonia </option>\
				<option value="ET">Ethiopia </option>\
				<option value="FK">Falkland Islands </option>\
				<option value="FO">Faroe Islands </option>\
				<option value="FJ">Fiji </option>\
				<option value="FI">Finland </option>\
				<option value="FR">France </option>\
				<option value="GF">French Guiana </option>\
				<option value="PF">French Polynesia </option>\
				<option value="TF">French Southern Territories </option>\
				<option value="GA">Gabon </option>\
				<option value="GM">Gambia </option>\
				<option value="GE">Georgia </option>\
				<option value="DE">Germany </option>\
				<option value="GH">Ghana </option>\
				<option value="GI">Gibraltar </option>\
				<option value="GR">Greece </option>\
				<option value="GL">Greenland </option>\
				<option value="GD">Grenada </option>\
				<option value="GP">Guadeloupe </option>\
				<option value="GU">Guam </option>\
				<option value="GT">Guatemala </option>\
				<option value="GN">Guinea </option>\
				<option value="GW">Guinea-Bissau </option>\
				<option value="GY">Guyana </option>\
				<option value="HT">Haiti </option>\
				<option value="HM">Heard and Mcdonald Islands </option>\
				<option value="HN">Honduras </option>\
				<option value="HK">Hong Kong </option>\
				<option value="HU">Hungary </option>\
				<option value="IS">Iceland </option>\
				<option value="IN">India </option>\
				<option value="ID">Indonesia </option>\
				<option value="IE">Ireland </option>\
				<option value="IL">Israel </option>\
				<option value="IT">Italy </option>\
				<option value="JM">Jamaica </option>\
				<option value="JP">Japan </option>\
				<option value="JO">Jordan </option>\
				<option value="KZ">Kazakhstan </option>\
				<option value="KE">Kenya </option>\
				<option value="KI">Kiribati </option>\
				<option value="KR">Korea, South </option>\
				<option value="KW">Kuwait </option>\
				<option value="KG">Kyrgyzstan </option>\
				<option value="LA">Laos, People`s Democratic Republic </option>\
				<option value="LV">Latvia </option>\
				<option value="LB">Lebanon </option>\
				<option value="LS">Lesotho </option>\
				<option value="LR">Liberia </option>\
				<option value="LI">Liechtenstein </option>\
				<option value="LT">Lithuania </option>\
				<option value="LU">Luxembourg </option>\
				<option value="MO">Macau </option>\
				<option value="MK">Macedonia </option>\
				<option value="MG">Madagascar </option>\
				<option value="MW">Malawi </option>\
				<option value="MY">Malaysia </option>\
				<option value="MV">Maldives </option>\
				<option value="ML">Mali </option>\
				<option value="MT">Malta </option>\
				<option value="MH">Marshall Islands </option>\
				<option value="MQ">Martinique </option>\
				<option value="MR">Mauritania </option>\
				<option value="MU">Mauritius </option>\
				<option value="YT">Mayotte </option>\
				<option value="MX">Mexico </option>\
				<option value="FM">Micronesia </option>\
				<option value="MD">Moldova </option>\
				<option value="MC">Monaco </option>\
				<option value="MN">Mongolia </option>\
				<option value="MS">Montserrat </option>\
				<option value="MA">Morocco </option>\
				<option value="MZ">Mozambique </option>\
				<option value="MM">Myanmar </option>\
				<option value="NA">Namibia </option>\
				<option value="NR">Nauru </option>\
				<option value="NP">Nepal </option>\
				<option value="NL">Netherlands </option>\
				<option value="AN">Netherlands Antilles </option>\
				<option value="NC">New Caledonia </option>\
				<option value="NZ">New Zealand </option>\
				<option value="NI">Nicaragua </option>\
				<option value="NE">Niger </option>\
				<option value="NG">Nigeria </option>\
				<option value="NU">Niue </option>\
				<option value="NF">Norfolk Island </option>\
				<option value="MP">Northern Mariana Islands </option>\
				<option value="NO">Norway </option>\
				<option value="OM">Oman </option>\
				<option value="PK">Pakistan </option>\
				<option value="PW">Palau </option>\
				<option value="PS">Palestinian Territory </option>\
				<option value="PA">Panama </option>\
				<option value="PG">Papua New Guinea </option>\
				<option value="PY">Paraguay </option>\
				<option value="PE">Peru </option>\
				<option value="PH">Philippines </option>\
				<option value="PN">Pitcairn </option>\
				<option value="PL">Poland </option>\
				<option value="PT">Portugal </option>\
				<option value="PR">Puerto Rico </option>\
				<option value="QA">Qatar </option>\
				<option value="RE">Reunion </option>\
				<option value="RO">Romania </option>\
				<option value="RU">Russian Federation </option>\
				<option value="RW">Rwanda </option>\
				<option value="KN">Saint Kitts and Nevis </option>\
				<option value="LC">Saint Lucia </option>\
				<option value="VC">Saint Vincent Islands </option>\
				<option value="WS">Samoa </option>\
				<option value="SM">San Marino </option>\
				<option value="ST">Sao Tome and Principe </option>\
				<option value="SA">Saudi Arabia </option>\
				<option value="SN">Senegal </option>\
				<option value="SC">Seychelles </option>\
				<option value="SL">Sierra Leone </option>\
				<option value="SG">Singapore </option>\
				<option value="SK">Slovak Republic </option>\
				<option value="SI">Slovenia </option>\
				<option value="GS">S.Georgia and S.Sandwich Is. </option>\
				<option value="SB">Solomon Islands </option>\
				<option value="SO">Somalia </option>\
				<option value="ZA">South Africa </option>\
				<option value="ES">Spain </option>\
				<option value="LK">Sri Lanka </option>\
				<option value="SH">St Helena </option>\
				<option value="PM">St Pierre and Miquelon </option>\
				<option value="SR">Suriname </option>\
				<option value="SJ">Svalbard and Jan Mayen Islands </option>\
				<option value="SZ">Swaziland </option>\
				<option value="SE">Sweden </option>\
				<option value="CH">Switzerland </option>\
				<option value="SY">Syria </option>\
				<option value="TW">Taiwan </option>\
				<option value="TJ">Tajikistan </option>\
				<option value="TZ">Tanzania, United Republic of </option>\
				<option value="TH">Thailand </option>\
				<option value="TG">Togo </option>\
				<option value="TK">Tokelau </option>\
				<option value="TO">Tonga </option>\
				<option value="TT">Trinidad and Tobago </option>\
				<option value="TN">Tunisia </option>\
				<option value="TR">Turkey </option>\
				<option value="TM">Turkmenistan </option>\
				<option value="TC">Turks and Caicos Islands </option>\
				<option value="TV">Tuvalu </option>\
				<option value="UG">Uganda </option>\
				<option value="UA">Ukraine </option>\
				<option value="AE">United Arab Emirates </option>\
				<option value="GB">United Kingdom </option>\
				<option value="US">United States </option>\
				<option value="UY">Uruguay </option>\
				<option value="UM">US Minor Outlying Islands </option>\
				<option value="UZ">Uzbekistan </option>\
				<option value="VU">Vanuatu </option>\
				<option value="VA">Vatican City State </option>\
				<option value="VE">Venezuela </option>\
				<option value="VN">Vietnam </option>\
				<option value="VG">Virgin Islands (British) </option>\
				<option value="VI">Virgin Islands (US) </option>\
				<option value="WF">Wallis and Futuna Islands </option>\
				<option value="EH">Western Sahara </option>\
				<option value="YE">Yemen </option>\
				<option value="ZM">Zambia </option>\
				<option value="ZW">Zimbabwe </option>\
				</select>';

//=======================================================================
// Application Usage Information
//=======================================================================
var AppUsageHTML = '\
					<select multiple name="appusage" size="4">\
					<option value="1">Architecture </option>\
					<option value="2">Building Services </option>\
					<option value="3">Civil Engineering </option>\
					<option value="4">Games </option>\
					<option value="5">GIS </option>\
					<option value="6">Mechanical </option>\
					<option value="7">Video Editing </option>\
					<option value="8">Other </option>\
					</select>';


//=======================================================================
// Geo Specfic Information
//=======================================================================

// Here are the variables that we are using in the pages
// The Switch statements populate them with the correct values
// as initialized previously
//
var InsertStPrRegSelect="";			// Select statement with all country options for state/province/region
var InsertStPrRegText=xmsgRegText;		// State, Province or Region text variable.  All but US&CAN use Region
var InsertZipPostText=PostHTML;			// Zip Code or Postal code?  All but US&CAN use Postal; US&CAN Set in switch
var InsertZipPostTextConfirm=PostHTMLConfirm;	// Confirmed Zip or Postal code.
var Geo="";					// Geo variable set based on country
var SalutationBlock="";

function SetCountryParms() {

	//	set the default online store url
xmsgOnlineStoreURL = xmsgOnlineStoreDefaultURL;

// Assign Geo, contact information, and salutations
switch (country) {
  case "AT": InsertStPrRegSelect=ATStPrRegHTML; //Austria zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk GmbH<br>Traungasse 16<br>A-4600 Wels";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "AU": InsertStPrRegSelect=AUStPrRegHTML; //Australia zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="1-800-331453 or 0011-800-4700-7280";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLAU;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "BR": 					//Brazil zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="000-811-994-5571";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "CH": InsertStPrRegSelect=CHStPrRegHTML; //Switzerland zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk AG<br>Zurlindenstrasse 29<br>CH-4133<br>Pratteln</p>";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "CL": 					//Chile zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="1230-020-2001";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "CN": InsertStPrRegSelect=CNStPrRegHTML; //China zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="86-10-6505-6858";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "CO": 					//Colombia zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="980-12-1311";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "CY": 					//Cyprus Republic zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="PO Box 3283<br>Nicosia";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "CZ": 					//Czech Republic zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk s.r.o<br>Jeseniova 1<br>CZ-13000 Prague 3";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "DE": InsertStPrRegSelect=DEStPrRegHTML; //Germany zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk GmbH<br>Hansastrasse 28<br>D-80686 Mnchen";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLDE;
			 break;
  case "DK":									//Denmark zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "ES": InsertStPrRegSelect=ESStPrRegHTML; //Spain zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk S.A.<br>C/Constitucion 1, Planta 4<br>08960 Sant Just, Barcelona";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "FI":									//Finland zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "FR":					//France zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk S.A.<br>Btiment les Ellipses<br>5, avenue du Chemin de Presles<br>94410 - Saint-Maurice";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLFR;
			 break;
  case "GB":					//United Kingdom zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk Ltd<br>Cross Lanes<br>Guildford, Surrey<br>GU1 1UJ";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLGB;
			 break;
  case "GR": 					//Greece zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="PO Box 75059, Z.C.<br>17610 Kalithea/Athens";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "GU": StateProvInvo="";			//Guam
			 InsertStPrRegText="";
			 InsertZipPostText=ZipHTML;
			 InsertZipPostTextConfirm=ZipHTMLConfirm;
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData=xmsgFormCallDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="US";
			 SalutationBlock=SalutationUS;
			 break;
  case "HK": InsertStPrRegSelect=HKStPrRegHTML; //Hong Kong zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="852-2-824-3228";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLHK;
			 break;
  case "HU": 					//Hungary zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk Ltd.<br>Arpad Center<br>H-1134, Budapest, Arboc.U.6<br>Hungary";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
 case "IN": 					//India zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="91 80 2072131";			 
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "IE": InsertStPrRegSelect=IEStPrRegHTML; //Ireland zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLIE;
			 break;
  case "IL": 					//Israel zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk<br>12 Ha'hilazon street<br>Ramat Gan<br>52522";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "IT": InsertStPrRegSelect=ITStPrRegHTML; //Italy zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk S.p.A.<br>Milanofiori,<br>Strada 4 Palazzo A5<br>20090 Assago MI";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLIT;
			 break;
  case "JM": 					//Jamaica zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
		 	 xmsgFormCallData="0800-551-1490";
		 	 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "JP": InsertStPrRegSelect=JPStPrRegHTML; //Japan zip 10
			 xmsgFormEmailData="japan.register@autodesk.com";
			 xmsgFormFaxData="81-03-3473-9512";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormCallData="03-3473-9529";			 
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLJP;
			 break;
  case "KR": 					//Korea, South zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="82-2-527-8716";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
		 	 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLKR;
			 break;
  case "MX": InsertStPrRegSelect=MXStPrRegHTML; //Mexico zip 10
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="95-800-551-1490";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "MY": InsertStPrRegSelect=MYStPrRegHTML; //Malaysia zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "NL": 					//Netherlands zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk B.V.<br>Postbus 8651<br>NL-3009 AR Rotterdam";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLNL;
			 break;
  case "NO":					//Norway zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "NZ": 
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="00-800-4700-7280";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLNZ;
			 break;
  case "PL": 					//Poland zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData="00-800-4700-7280";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk GmbH Oddzial<br>w Warszawie<br>ul. W. Rzymowskiego 34<br>02-697 Warszawa";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "PT": InsertStPrRegSelect=PTStPrRegHTML; //Portugal zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk Software Limited<br>Apartado 152<br>2670 Loures";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "RU": 					//Russian Federation zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "SE":							//Sweden zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk AB<br>Mlndalsvgen 24<br>Box 14261<br>S-400 20 Gteborg";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLSE;
			 break;
  case "SG": 
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLSG;
			 break;
  case "TH": 
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "TW": InsertStPrRegSelect=TWStPrRegHTML; //Taiwan zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="886-2546-1223";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLTW;
			 break;
  case "US": InsertStPrRegSelect=USStPrRegHTML; //United States zip 5-4
			 InsertStPrRegText=xmsgStText;
			 InsertZipPostText=ZipHTML;
			 InsertZipPostTextConfirm=ZipHTMLConfirm;
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData=xmsgFormCallDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="US";
			 SalutationBlock=SalutationUS;
			 break;
  case "ZA": 					//South Africa zip 10				
			 InsertStPrRegSelect=""; 
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=' (thin envelopes)<br>Autodesk Ltd.<br>PO Box 7398<br>\
                                            Centurion 0046<p>(parcels)<br>Autodesk Ltd.<br>Grand Floor<br>\
	                                    International<br>Business Gateway<br>New Road, Midrand</p>';
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;


  case "CA": //Canada zip 3-3
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLCA;
  case "PM": //St Pierre and Miquelon
			 InsertStPrRegSelect=CAStPrRegHTML;
			 InsertStPrRegText=xmsgPrText;
			 InsertZipPostText=PostHTML;	//Use CanPostHTML with ereg.dll support in future
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData=xmsgFormCallDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="CAN";
			 SalutationBlock=SalutationUS;
			 break;


  case "AS": //American Samoa
  case "AQ": //Antarctica
  case "BD": //Bangladesh
  case "BT": //Bhutan
  case "KH": //Cambodia
  case "CX": //Christmas Island (Australia)
  case "CC": //Cocos (Keeling) Islands
  case "CK": //Cook Islands (New Zealand)
  case "TP": //East Timor
  case "FJ": //Fiji
  case "PF": //French Polynesia
  case "TF": //French Southern Territories
  case "HM": //Heard and Mcdonald Islands
  case "ID": //Indonesia
  case "KI": //Kiribati
  case "LA": //Laos, People's Democratic Republic
  case "MO": //Macau
  case "MV": //Maldives
  case "MH": //Marshall Islands
  case "FM": //Micronesia
  case "MM": //Myanmar
  case "NR": //Nauru
  case "NP": //Nepal
  case "NU": //Niue
  case "NF": //Norfolk Island
  case "MP": //Northern Mariana Islands
  case "PK": //Pakistan
  case "PW": //Palau
  case "PG": //Papua New Guinea
  case "PH": //Philippines
  case "PN": //Pitcairn
  case "WS": //Samoa
  case "SB": //Solomon Islands
  case "LK": //Sri Lanka
  case "TK": //Tokelau
  case "TO": //Tonga
  case "TV": //Tuvalu
  case "UM": //US Minor Outlying Islands
  case "VU": //Vanuatu
  case "VN": //Vietnam
  case "WF": //Wallis and Futuna Islands
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;


  case "AL": //Albania
  case "DZ": //Algeria
  case "AD": //Andorra
  case "AO": //Angola
  case "AM": //Armenia
  case "AZ": //Azerbaijan
  case "BH": //Bahrain
  case "BY": //Belarus
  case "BE": //Belgium
		if (country == "BE")
			xmsgOnlineStoreURL=xmsgOnlineStoreURLBE;
  case "BJ": //Benin
  case "BA": //Bosnia and Herzegovina
  case "BW": //Botswana
  case "BV": //Bouvet Island
  case "IO": //British Indian Ocean Territory
  case "BN": //Brunei Darussalam
  case "BG": //Bulgaria
  case "BF": //Burkina Faso
  case "BI": //Burundi
  case "CM": //Cameroon
  case "CV": //Cape Verde
  case "CF": //Central African Republic
  case "TD": //Chad
  case "KM": //Comoros
  case "CG": //Congo
  case "CI": //Cote d'Ivoire
  case "HR": //Croatia (Hrvatska)
  case "CD": //Democratic Republic of the Congo
  case "DJ": //Djibouti
  case "EG": //Egypt
  case "GQ": //Equatorial Guinea
  case "ER": //Eritrea
  case "EE": //Estonia
  case "ET": //Ethiopia
  case "FO": //Faroe Islands
  case "GA": //Gabon
  case "GM": //Gambia
  case "GE": //Georgia
  case "GH": //Ghana
  case "GI": //Gibraltar
  case "GL": //Greenland
  case "GP": //Guadeloupe
  case "GN": //Guinea
  case "GW": //Guinea-Bissau
  case "IS": //Iceland
  case "JO": //Jordan
  case "KZ": //Kazakhstan
  case "KE": //Kenya
  case "KW": //Kuwait
  case "KG": //Kyrgyzstan
  case "LV": //Latvia
  case "LB": //Lebanon
  case "LS": //Lesotho
  case "LR": //Liberia
  case "LI": //Liechtenstein
  case "LT": //Lithuania
  case "LU": //Luxembourg
  case "MK": //Macedonia
  case "MG": //Madagascar
  case "MW": //Malawi
  case "ML": //Mali
  case "MT": //Malta
  case "MR": //Mauritania
  case "MU": //Mauritius
  case "YT": //Mayotte
  case "MD": //Moldova
  case "MC": //Monaco
  case "MN": //Mongolia
  case "MA": //Morocco
  case "MZ": //Mozambique
  case "NA": //Namibia
  case "AN": //Netherlands Antilles
  case "NC": //New Caledonia
  case "NE": //Niger
  case "NG": //Nigeria
  case "OM": //Oman
  case "PS": //Palestinian Territory
  case "QA": //Qatar
  case "RE": //Reunion
  case "RO": //Romania
  case "RW": //Rwanda
  case "SM": //San Marino
  case "ST": //Sao Tome and Principe
  case "SA": //Saudi Arabia
  case "SN": //Senegal
  case "SC": //Seychelles
  case "SL": //Sierra Leone
  case "SK": //Slovak Republic
  case "SI": //Slovenia
  case "SO": //Somalia
  case "SH": //St Helena
  case "SJ": //Svalbard and Jan Mayen Islands
  case "SZ": //Swaziland
  case "SY": //Syria
  case "TJ": //Tajikistan
  case "TZ": //Tanzania, United Republic of
  case "TG": //Togo
  case "TN": //Tunisia
  case "TR": //Turkey
  case "TM": //Turkmenistan
  case "UG": //Uganda
  case "UA": //Ukraine
  case "AE": //United Arab Emirates
  case "UZ": //Uzbekistan
  case "VA": //Vatican City State
  case "EH": //Western Sahara
  case "YE": //Yemen
  case "ZM": //Zambia
  case "ZW": //Zimbabwe
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;


  case "AI": //Anguilla
  case "AG": //Antigua and Barbuda
  case "AR": //Argentina
  case "AW": //Aruba
  case "BS": //Bahamas
  case "BB": //Barbados
  case "BZ": //Belize
  case "BM": //Bermuda
  case "BO": //Bolivia
  case "KY": //Cayman Islands
  case "CR": //Costa Rica
  case "DM": //Dominica
  case "DO": //Dominican Republic
  case "EC": //Ecuador
  case "SV": //El Salvador
  case "FK": //Falkland Islands
  case "GF": //French Guiana
  case "GD": //Grenada
  case "GT": //Guatemala
  case "GY": //Guyana
  case "HT": //Haiti
  case "HN": //Honduras
  case "MQ": //Martinique
  case "MS": //Montserrat
  case "NI": //Nicaragua
  case "PA": //Panama
  case "PY": //Paraguay
  case "PE": //Peru
  case "PR": //Puerto Rico
  case "GS": //S. Georgia and S. Sandwich Is.
  case "KN": //Saint Kitts and Nevis
  case "LC": //Saint Lucia
  case "VC": //Saint Vincent Islands
  case "SR": //Suriname
  case "TT": //Trinidad and Tobago
  case "TC": //Turks and Caicos Islands
  case "UY": //Uruguay
  case "VE": //Venezuela
  case "VG": //Virgin Islands (British)
  case "VI": //Virgin Islands (US)
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  default  : //!!!Unknown codes we make empty and alert
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 Geo="";
			 SalutationBlock="";
			 if (country != "select")
				alert("Error: No known country code input!");
			 break;
}

}

// Turn off the right click context menu
document.oncontextmenu=fnSuppress;
function fnSuppress() {
    return false;
}

